package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteUsageLimitResponse(
    usageLimit: Optional[zio.aws.redshiftserverless.model.UsageLimit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse = {
    import DeleteUsageLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse
      .builder()
      .optionallyWith(usageLimit.map(value => value.buildAwsValue()))(
        _.usageLimit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteUsageLimitResponse
      .wrap(buildAwsValue())
}
object DeleteUsageLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteUsageLimitResponse =
      zio.aws.redshiftserverless.model
        .DeleteUsageLimitResponse(usageLimit.map(value => value.asEditable))
    def usageLimit
        : Optional[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly]
    def getUsageLimit: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
    ] = AwsError.unwrapOptionField("usageLimit", usageLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse
  ) extends zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly {
    override val usageLimit
        : Optional[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageLimit())
        .map(value => zio.aws.redshiftserverless.model.UsageLimit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse
  ): zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly =
    new Wrapper(impl)
}
