package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{NamespaceName, Integer}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNamespaceRequest(
    finalSnapshotName: Optional[String] = Optional.Absent,
    finalSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    namespaceName: NamespaceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest = {
    import DeleteNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest
      .builder()
      .optionallyWith(finalSnapshotName.map(value => value: java.lang.String))(
        _.finalSnapshotName
      )
      .optionallyWith(
        finalSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.finalSnapshotRetentionPeriod)
      .namespaceName(NamespaceName.unwrap(namespaceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteNamespaceRequest.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteNamespaceRequest
      .wrap(buildAwsValue())
}
object DeleteNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteNamespaceRequest =
      zio.aws.redshiftserverless.model.DeleteNamespaceRequest(
        finalSnapshotName.map(value => value),
        finalSnapshotRetentionPeriod.map(value => value),
        namespaceName
      )
    def finalSnapshotName: Optional[String]
    def finalSnapshotRetentionPeriod: Optional[Integer]
    def namespaceName: NamespaceName
    def getFinalSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("finalSnapshotName", finalSnapshotName)
    def getFinalSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "finalSnapshotRetentionPeriod",
        finalSnapshotRetentionPeriod
      )
    def getNamespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest
  ) extends zio.aws.redshiftserverless.model.DeleteNamespaceRequest.ReadOnly {
    override val finalSnapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.finalSnapshotName())
      .map(value => value: String)
    override val finalSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val namespaceName: NamespaceName =
      zio.aws.redshiftserverless.model.primitives
        .NamespaceName(impl.namespaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest
  ): zio.aws.redshiftserverless.model.DeleteNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
