package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcEndpoint(
    networkInterfaces: Optional[
      Iterable[zio.aws.redshiftserverless.model.NetworkInterface]
    ] = Optional.Absent,
    vpcEndpointId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.VpcEndpoint
      .builder()
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly =
    zio.aws.redshiftserverless.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.VpcEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.VpcEndpoint =
      zio.aws.redshiftserverless.model.VpcEndpoint(
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpointId.map(value => value),
        vpcId.map(value => value)
      )
    def networkInterfaces: Optional[
      List[zio.aws.redshiftserverless.model.NetworkInterface.ReadOnly]
    ]
    def vpcEndpointId: Optional[String]
    def vpcId: Optional[String]
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.VpcEndpoint
  ) extends zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly {
    override val networkInterfaces: Optional[
      List[zio.aws.redshiftserverless.model.NetworkInterface.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.NetworkInterface.wrap(item)
        }.toList
      )
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.VpcEndpoint
  ): zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
