package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUsageLimitResponse(
    usageLimit: Optional[zio.aws.redshiftserverless.model.UsageLimit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse = {
    import UpdateUsageLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse
      .builder()
      .optionallyWith(usageLimit.map(value => value.buildAwsValue()))(
        _.usageLimit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateUsageLimitResponse
      .wrap(buildAwsValue())
}
object UpdateUsageLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UpdateUsageLimitResponse =
      zio.aws.redshiftserverless.model
        .UpdateUsageLimitResponse(usageLimit.map(value => value.asEditable))
    def usageLimit
        : Optional[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly]
    def getUsageLimit: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
    ] = AwsError.unwrapOptionField("usageLimit", usageLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse
  ) extends zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly {
    override val usageLimit
        : Optional[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageLimit())
        .map(value => zio.aws.redshiftserverless.model.UsageLimit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse
  ): zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly =
    new Wrapper(impl)
}
