package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.VpcSecurityGroupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEndpointAccessRequest(
    endpointName: String,
    vpcSecurityGroupIds: Optional[Iterable[VpcSecurityGroupId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest = {
    import UpdateEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest
      .builder()
      .endpointName(endpointName: java.lang.String)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            VpcSecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest
      .wrap(buildAwsValue())
}
object UpdateEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest =
      zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest(
        endpointName,
        vpcSecurityGroupIds.map(value => value)
      )
    def endpointName: String
    def vpcSecurityGroupIds: Optional[List[VpcSecurityGroupId]]
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[VpcSecurityGroupId]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest
  ) extends zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
    override val vpcSecurityGroupIds: Optional[List[VpcSecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.primitives.VpcSecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest
  ): zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
