package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.{TagKey, AmazonResourceName}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UntagResourceRequest.ReadOnly =
    zio.aws.redshiftserverless.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UntagResourceRequest =
      zio.aws.redshiftserverless.model
        .UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AmazonResourceName
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest
  ) extends zio.aws.redshiftserverless.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.redshiftserverless.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.redshiftserverless.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest
  ): zio.aws.redshiftserverless.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
