package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSnapshotsResponse(
    nextToken: Optional[String] = Optional.Absent,
    snapshots: Optional[Iterable[zio.aws.redshiftserverless.model.Snapshot]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse = {
    import ListSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListSnapshotsResponse.wrap(buildAwsValue())
}
object ListSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListSnapshotsResponse =
      zio.aws.redshiftserverless.model.ListSnapshotsResponse(
        nextToken.map(value => value),
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def snapshots
        : Optional[List[zio.aws.redshiftserverless.model.Snapshot.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSnapshots: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.Snapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshots", snapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse
  ) extends zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val snapshots
        : Optional[List[zio.aws.redshiftserverless.model.Snapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.Snapshot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse
  ): zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
