package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNamespacesResponse(
    namespaces: Iterable[zio.aws.redshiftserverless.model.Namespace],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse = {
    import ListNamespacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse
      .builder()
      .namespaces(namespaces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListNamespacesResponse
      .wrap(buildAwsValue())
}
object ListNamespacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListNamespacesResponse =
      zio.aws.redshiftserverless.model.ListNamespacesResponse(
        namespaces.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def namespaces: List[zio.aws.redshiftserverless.model.Namespace.ReadOnly]
    def nextToken: Optional[String]
    def getNamespaces: ZIO[Any, Nothing, List[
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ]] = ZIO.succeed(namespaces)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse
  ) extends zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly {
    override val namespaces
        : List[zio.aws.redshiftserverless.model.Namespace.ReadOnly] = impl
      .namespaces()
      .asScala
      .map { item =>
        zio.aws.redshiftserverless.model.Namespace.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse
  ): zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly =
    new Wrapper(impl)
}
