package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(resourceArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest =
      zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest(resourceArn)
    def resourceArn: String
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest
  ) extends zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest
  ): zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
