package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEndpointAccessRequest(endpointName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest = {
    import DeleteEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest
      .builder()
      .endpointName(endpointName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest
      .wrap(buildAwsValue())
}
object DeleteEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest =
      zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest(endpointName)
    def endpointName: String
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest
  ) extends zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest
  ): zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
