package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEndpointAccessResponse(
    endpoint: Optional[zio.aws.redshiftserverless.model.EndpointAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse = {
    import CreateEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly =
    zio.aws.redshiftserverless.model.CreateEndpointAccessResponse
      .wrap(buildAwsValue())
}
object CreateEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.CreateEndpointAccessResponse =
      zio.aws.redshiftserverless.model
        .CreateEndpointAccessResponse(endpoint.map(value => value.asEditable))
    def endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse
  ) extends zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly {
    override val endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value =>
          zio.aws.redshiftserverless.model.EndpointAccess.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse
  ): zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
