package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateWorkgroupResponse(
    workgroup: zio.aws.redshiftserverless.model.Workgroup
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse = {
    import UpdateWorkgroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse
      .builder()
      .workgroup(workgroup.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateWorkgroupResponse
      .wrap(buildAwsValue())
}
object UpdateWorkgroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UpdateWorkgroupResponse =
      zio.aws.redshiftserverless.model
        .UpdateWorkgroupResponse(workgroup.asEditable)
    def workgroup: zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    def getWorkgroup: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    ] = ZIO.succeed(workgroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse
  ) extends zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly {
    override val workgroup
        : zio.aws.redshiftserverless.model.Workgroup.ReadOnly =
      zio.aws.redshiftserverless.model.Workgroup.wrap(impl.workgroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse
  ): zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly =
    new Wrapper(impl)
}
