package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNamespaceResponse(
    namespace: zio.aws.redshiftserverless.model.Namespace
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse = {
    import DeleteNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse
      .builder()
      .namespace(namespace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteNamespaceResponse
      .wrap(buildAwsValue())
}
object DeleteNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteNamespaceResponse =
      zio.aws.redshiftserverless.model
        .DeleteNamespaceResponse(namespace.asEditable)
    def namespace: zio.aws.redshiftserverless.model.Namespace.ReadOnly
    def getNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = ZIO.succeed(namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse
  ) extends zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly {
    override val namespace
        : zio.aws.redshiftserverless.model.Namespace.ReadOnly =
      zio.aws.redshiftserverless.model.Namespace.wrap(impl.namespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse
  ): zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
