package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUsageLimitResponse(
    usageLimit: Optional[zio.aws.redshiftserverless.model.UsageLimit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse = {
    import CreateUsageLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse
      .builder()
      .optionallyWith(usageLimit.map(value => value.buildAwsValue()))(
        _.usageLimit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly =
    zio.aws.redshiftserverless.model.CreateUsageLimitResponse
      .wrap(buildAwsValue())
}
object CreateUsageLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateUsageLimitResponse =
      zio.aws.redshiftserverless.model
        .CreateUsageLimitResponse(usageLimit.map(value => value.asEditable))
    def usageLimit
        : Optional[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly]
    def getUsageLimit: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
    ] = AwsError.unwrapOptionField("usageLimit", usageLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse
  ) extends zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly {
    override val usageLimit
        : Optional[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageLimit())
        .map(value => zio.aws.redshiftserverless.model.UsageLimit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse
  ): zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly =
    new Wrapper(impl)
}
