package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  VpcSecurityGroupId,
  SubnetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEndpointAccessRequest(
    endpointName: String,
    subnetIds: Iterable[SubnetId],
    vpcSecurityGroupIds: Optional[Iterable[VpcSecurityGroupId]] =
      Optional.Absent,
    workgroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest = {
    import CreateEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest
      .builder()
      .endpointName(endpointName: java.lang.String)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            VpcSecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .workgroupName(workgroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateEndpointAccessRequest.ReadOnly =
    zio.aws.redshiftserverless.model.CreateEndpointAccessRequest
      .wrap(buildAwsValue())
}
object CreateEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.CreateEndpointAccessRequest =
      zio.aws.redshiftserverless.model.CreateEndpointAccessRequest(
        endpointName,
        subnetIds,
        vpcSecurityGroupIds.map(value => value),
        workgroupName
      )
    def endpointName: String
    def subnetIds: List[SubnetId]
    def vpcSecurityGroupIds: Optional[List[VpcSecurityGroupId]]
    def workgroupName: String
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[VpcSecurityGroupId]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getWorkgroupName: ZIO[Any, Nothing, String] = ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest
  ) extends zio.aws.redshiftserverless.model.CreateEndpointAccessRequest.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.redshiftserverless.model.primitives.SubnetId(item)
      }
      .toList
    override val vpcSecurityGroupIds: Optional[List[VpcSecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.primitives.VpcSecurityGroupId(item)
          }.toList
        )
    override val workgroupName: String = impl.workgroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest
  ): zio.aws.redshiftserverless.model.CreateEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
