package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConvertRecoveryPointToSnapshotRequest(
    recoveryPointId: String,
    retentionPeriod: Optional[Integer] = Optional.Absent,
    snapshotName: String,
    tags: Optional[Iterable[zio.aws.redshiftserverless.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest = {
    import ConvertRecoveryPointToSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
      .builder()
      .recoveryPointId(recoveryPointId: java.lang.String)
      .optionallyWith(retentionPeriod.map(value => value: java.lang.Integer))(
        _.retentionPeriod
      )
      .snapshotName(snapshotName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
      .wrap(buildAwsValue())
}
object ConvertRecoveryPointToSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest =
      zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest(
        recoveryPointId,
        retentionPeriod.map(value => value),
        snapshotName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recoveryPointId: String
    def retentionPeriod: Optional[Integer]
    def snapshotName: String
    def tags: Optional[List[zio.aws.redshiftserverless.model.Tag.ReadOnly]]
    def getRecoveryPointId: ZIO[Any, Nothing, String] =
      ZIO.succeed(recoveryPointId)
    def getRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
  ) extends zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest.ReadOnly {
    override val recoveryPointId: String = impl.recoveryPointId(): String
    override val retentionPeriod: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPeriod())
      .map(value => value: Integer)
    override val snapshotName: String = impl.snapshotName(): String
    override val tags
        : Optional[List[zio.aws.redshiftserverless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
  ): zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
