package zio.aws.redshiftserverless
import zio.aws.redshiftserverless.model.GetNamespaceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.redshiftserverless.model.{
  UpdateUsageLimitRequest,
  GetRecoveryPointRequest,
  GetCredentialsRequest,
  DeleteSnapshotRequest,
  ListSnapshotsRequest,
  ListNamespacesRequest,
  RestoreFromSnapshotRequest,
  UpdateSnapshotRequest,
  PutResourcePolicyRequest,
  CreateNamespaceRequest,
  UpdateEndpointAccessRequest,
  CreateWorkgroupRequest,
  ListTagsForResourceRequest,
  DeleteNamespaceRequest,
  RestoreTableFromSnapshotRequest,
  UpdateWorkgroupRequest,
  RestoreFromRecoveryPointRequest,
  GetWorkgroupRequest,
  DeleteUsageLimitRequest,
  ListEndpointAccessRequest,
  CreateUsageLimitRequest,
  ListWorkgroupsRequest,
  ListTableRestoreStatusRequest,
  DeleteResourcePolicyRequest,
  ListUsageLimitsRequest,
  UntagResourceRequest,
  GetTableRestoreStatusRequest,
  ListRecoveryPointsRequest,
  GetEndpointAccessRequest,
  CreateSnapshotRequest,
  DeleteWorkgroupRequest,
  GetSnapshotRequest,
  GetResourcePolicyRequest,
  CreateEndpointAccessRequest,
  GetUsageLimitRequest,
  UpdateNamespaceRequest,
  TagResourceRequest,
  ConvertRecoveryPointToSnapshotRequest,
  GetNamespaceRequest,
  DeleteEndpointAccessRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient
import zio.stream.ZStream
object RedshiftServerlessMock extends Mock[RedshiftServerless] {
  object RestoreTableFromSnapshot
      extends Effect[
        RestoreTableFromSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly
      ]
  object ListTableRestoreStatus
      extends Stream[
        ListTableRestoreStatusRequest,
        AwsError,
        zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
      ]
  object ListTableRestoreStatusPaginated
      extends Effect[
        ListTableRestoreStatusRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly
      ]
  object UpdateNamespace
      extends Effect[
        UpdateNamespaceRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly
      ]
  object CreateWorkgroup
      extends Effect[
        CreateWorkgroupRequest,
        AwsError,
        zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly
      ]
  object DeleteWorkgroup
      extends Effect[
        DeleteWorkgroupRequest,
        AwsError,
        zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly
      ]
  object ListEndpointAccess
      extends Stream[
        ListEndpointAccessRequest,
        AwsError,
        zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
      ]
  object ListEndpointAccessPaginated
      extends Effect[
        ListEndpointAccessRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly
      ]
  object GetNamespace extends Effect[GetNamespaceRequest, AwsError, ReadOnly]
  object GetWorkgroup
      extends Effect[
        GetWorkgroupRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly
      ]
  object GetSnapshot
      extends Effect[
        GetSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetSnapshotResponse.ReadOnly
      ]
  object GetUsageLimit
      extends Effect[
        GetUsageLimitRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetUsageLimitResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly
      ]
  object DeleteUsageLimit
      extends Effect[
        DeleteUsageLimitRequest,
        AwsError,
        zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly
      ]
  object DeleteEndpointAccess
      extends Effect[
        DeleteEndpointAccessRequest,
        AwsError,
        zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly
      ]
  object ListRecoveryPoints
      extends Stream[
        ListRecoveryPointsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
      ]
  object ListRecoveryPointsPaginated
      extends Effect[
        ListRecoveryPointsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly
      ]
  object GetRecoveryPoint
      extends Effect[
        GetRecoveryPointRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly
      ]
  object GetCredentials
      extends Effect[
        GetCredentialsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly
      ]
  object CreateEndpointAccess
      extends Effect[
        CreateEndpointAccessRequest,
        AwsError,
        zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly
      ]
  object DeleteSnapshot
      extends Effect[
        DeleteSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly
      ]
  object ListNamespaces
      extends Stream[
        ListNamespacesRequest,
        AwsError,
        zio.aws.redshiftserverless.model.Namespace.ReadOnly
      ]
  object ListNamespacesPaginated
      extends Effect[
        ListNamespacesRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly
      ]
  object GetEndpointAccess
      extends Effect[
        GetEndpointAccessRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly
      ]
  object CreateNamespace
      extends Effect[
        CreateNamespaceRequest,
        AwsError,
        zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly
      ]
  object UpdateSnapshot
      extends Effect[
        UpdateSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UntagResourceResponse.ReadOnly
      ]
  object ListUsageLimits
      extends Stream[
        ListUsageLimitsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
      ]
  object ListUsageLimitsPaginated
      extends Effect[
        ListUsageLimitsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly
      ]
  object UpdateWorkgroup
      extends Effect[
        UpdateWorkgroupRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.redshiftserverless.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object ListWorkgroups
      extends Stream[
        ListWorkgroupsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.Workgroup.ReadOnly
      ]
  object ListWorkgroupsPaginated
      extends Effect[
        ListWorkgroupsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateUsageLimit
      extends Effect[
        UpdateUsageLimitRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly
      ]
  object CreateUsageLimit
      extends Effect[
        CreateUsageLimitRequest,
        AwsError,
        zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.redshiftserverless.model.TagResourceResponse.ReadOnly
      ]
  object GetTableRestoreStatus
      extends Effect[
        GetTableRestoreStatusRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly
      ]
  object ListSnapshots
      extends Stream[
        ListSnapshotsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.Snapshot.ReadOnly
      ]
  object ListSnapshotsPaginated
      extends Effect[
        ListSnapshotsRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly
      ]
  object UpdateEndpointAccess
      extends Effect[
        UpdateEndpointAccessRequest,
        AwsError,
        zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly
      ]
  object RestoreFromSnapshot
      extends Effect[
        RestoreFromSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly
      ]
  object DeleteNamespace
      extends Effect[
        DeleteNamespaceRequest,
        AwsError,
        zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly
      ]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly
      ]
  object RestoreFromRecoveryPoint
      extends Effect[
        RestoreFromRecoveryPointRequest,
        AwsError,
        zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly
      ]
  object ConvertRecoveryPointToSnapshot
      extends Effect[
        ConvertRecoveryPointToSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly
      ]
  object CreateSnapshot
      extends Effect[
        CreateSnapshotRequest,
        AwsError,
        zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, RedshiftServerless] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, RedshiftServerless] { rts =>
        zio.ZIO.succeed {
          new RedshiftServerless {
            val api: RedshiftServerlessAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): RedshiftServerless = this
            def restoreTableFromSnapshot(
                request: RestoreTableFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly
            ] = proxy(RestoreTableFromSnapshot, request)
            def listTableRestoreStatus(
                request: ListTableRestoreStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTableRestoreStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTableRestoreStatusPaginated(
                request: ListTableRestoreStatusRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly
            ] = proxy(ListTableRestoreStatusPaginated, request)
            def updateNamespace(request: UpdateNamespaceRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly
            ] = proxy(UpdateNamespace, request)
            def createWorkgroup(request: CreateWorkgroupRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly
            ] = proxy(CreateWorkgroup, request)
            def deleteWorkgroup(request: DeleteWorkgroupRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly
            ] = proxy(DeleteWorkgroup, request)
            def listEndpointAccess(request: ListEndpointAccessRequest): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEndpointAccess, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEndpointAccessPaginated(
                request: ListEndpointAccessRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly
            ] = proxy(ListEndpointAccessPaginated, request)
            def getNamespace(
                request: GetNamespaceRequest
            ): IO[AwsError, ReadOnly] = proxy(GetNamespace, request)
            def getWorkgroup(request: GetWorkgroupRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly
            ] = proxy(GetWorkgroup, request)
            def getSnapshot(request: GetSnapshotRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetSnapshotResponse.ReadOnly
            ] = proxy(GetSnapshot, request)
            def getUsageLimit(request: GetUsageLimitRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetUsageLimitResponse.ReadOnly
            ] = proxy(GetUsageLimit, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def deleteUsageLimit(request: DeleteUsageLimitRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly
            ] = proxy(DeleteUsageLimit, request)
            def deleteEndpointAccess(request: DeleteEndpointAccessRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly
            ] = proxy(DeleteEndpointAccess, request)
            def listRecoveryPoints(request: ListRecoveryPointsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecoveryPoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecoveryPointsPaginated(
                request: ListRecoveryPointsRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly
            ] = proxy(ListRecoveryPointsPaginated, request)
            def getRecoveryPoint(request: GetRecoveryPointRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly
            ] = proxy(GetRecoveryPoint, request)
            def getCredentials(request: GetCredentialsRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly
            ] = proxy(GetCredentials, request)
            def createEndpointAccess(request: CreateEndpointAccessRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly
            ] = proxy(CreateEndpointAccess, request)
            def deleteSnapshot(request: DeleteSnapshotRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly
            ] = proxy(DeleteSnapshot, request)
            def listNamespaces(request: ListNamespacesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.Namespace.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNamespaces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNamespacesPaginated(request: ListNamespacesRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly
            ] = proxy(ListNamespacesPaginated, request)
            def getEndpointAccess(request: GetEndpointAccessRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly
            ] = proxy(GetEndpointAccess, request)
            def createNamespace(request: CreateNamespaceRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly
            ] = proxy(CreateNamespace, request)
            def updateSnapshot(request: UpdateSnapshotRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly
            ] = proxy(UpdateSnapshot, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listUsageLimits(request: ListUsageLimitsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUsageLimits, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUsageLimitsPaginated(request: ListUsageLimitsRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly
            ] = proxy(ListUsageLimitsPaginated, request)
            def updateWorkgroup(request: UpdateWorkgroupRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly
            ] = proxy(UpdateWorkgroup, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def listWorkgroups(request: ListWorkgroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.Workgroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkgroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkgroupsPaginated(request: ListWorkgroupsRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly
            ] = proxy(ListWorkgroupsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def updateUsageLimit(request: UpdateUsageLimitRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly
            ] = proxy(UpdateUsageLimit, request)
            def createUsageLimit(request: CreateUsageLimitRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly
            ] = proxy(CreateUsageLimit, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getTableRestoreStatus(
                request: GetTableRestoreStatusRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly
            ] = proxy(GetTableRestoreStatus, request)
            def listSnapshots(request: ListSnapshotsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.redshiftserverless.model.Snapshot.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSnapshots, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSnapshotsPaginated(request: ListSnapshotsRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly
            ] = proxy(ListSnapshotsPaginated, request)
            def updateEndpointAccess(request: UpdateEndpointAccessRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly
            ] = proxy(UpdateEndpointAccess, request)
            def restoreFromSnapshot(request: RestoreFromSnapshotRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly
            ] = proxy(RestoreFromSnapshot, request)
            def deleteNamespace(request: DeleteNamespaceRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly
            ] = proxy(DeleteNamespace, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
            def restoreFromRecoveryPoint(
                request: RestoreFromRecoveryPointRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly
            ] = proxy(RestoreFromRecoveryPoint, request)
            def convertRecoveryPointToSnapshot(
                request: ConvertRecoveryPointToSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly
            ] = proxy(ConvertRecoveryPointToSnapshot, request)
            def createSnapshot(request: CreateSnapshotRequest): IO[
              AwsError,
              zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly
            ] = proxy(CreateSnapshot, request)
          }
        }
      }
    }
  }
}
