package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreFromSnapshotResponse(
    namespace: Optional[zio.aws.redshiftserverless.model.Namespace] =
      Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse = {
    import RestoreFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse
      .builder()
      .optionallyWith(namespace.map(value => value.buildAwsValue()))(
        _.namespace
      )
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly =
    zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse =
      zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse(
        namespace.map(value => value.asEditable),
        ownerAccount.map(value => value),
        snapshotName.map(value => value)
      )
    def namespace: Optional[zio.aws.redshiftserverless.model.Namespace.ReadOnly]
    def ownerAccount: Optional[String]
    def snapshotName: Optional[String]
    def getNamespace: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = AwsError.unwrapOptionField("namespace", namespace)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse
  ) extends zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly {
    override val namespace
        : Optional[zio.aws.redshiftserverless.model.Namespace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value => zio.aws.redshiftserverless.model.Namespace.wrap(value))
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse
  ): zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
