package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourcePolicy(
    policy: Optional[String] = Optional.Absent,
    resourceArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ResourcePolicy = {
    import ResourcePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ResourcePolicy
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly =
    zio.aws.redshiftserverless.model.ResourcePolicy.wrap(buildAwsValue())
}
object ResourcePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ResourcePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ResourcePolicy =
      zio.aws.redshiftserverless.model.ResourcePolicy(
        policy.map(value => value),
        resourceArn.map(value => value)
      )
    def policy: Optional[String]
    def resourceArn: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ResourcePolicy
  ) extends zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ResourcePolicy
  ): zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly = new Wrapper(
    impl
  )
}
