package zio.aws.redshiftserverless.model
import scala.jdk.CollectionConverters._
sealed trait NamespaceStatus {
  def unwrap
      : software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus
}
object NamespaceStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus
  ): zio.aws.redshiftserverless.model.NamespaceStatus = value match {
    case software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.MODIFYING =>
      val r = MODIFYING
      r
    case software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftserverless.model.NamespaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus =
      software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE
      extends zio.aws.redshiftserverless.model.NamespaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus =
      software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.AVAILABLE
  }
  case object MODIFYING
      extends zio.aws.redshiftserverless.model.NamespaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus =
      software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.MODIFYING
  }
  case object DELETING
      extends zio.aws.redshiftserverless.model.NamespaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus =
      software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus.DELETING
  }
}
