package zio.aws.redshiftserverless.model
import scala.jdk.CollectionConverters._
sealed trait LogExport {
  def unwrap: software.amazon.awssdk.services.redshiftserverless.model.LogExport
}
object LogExport {
  def wrap(
      value: software.amazon.awssdk.services.redshiftserverless.model.LogExport
  ): zio.aws.redshiftserverless.model.LogExport = value match {
    case software.amazon.awssdk.services.redshiftserverless.model.LogExport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftserverless.model.LogExport.USERACTIVITYLOG =>
      val r = useractivitylog
      r
    case software.amazon.awssdk.services.redshiftserverless.model.LogExport.USERLOG =>
      val r = userlog
      r
    case software.amazon.awssdk.services.redshiftserverless.model.LogExport.CONNECTIONLOG =>
      val r = connectionlog
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftserverless.model.LogExport {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.LogExport =
      software.amazon.awssdk.services.redshiftserverless.model.LogExport.UNKNOWN_TO_SDK_VERSION
  }
  case object useractivitylog
      extends zio.aws.redshiftserverless.model.LogExport {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.LogExport =
      software.amazon.awssdk.services.redshiftserverless.model.LogExport.USERACTIVITYLOG
  }
  case object userlog extends zio.aws.redshiftserverless.model.LogExport {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.LogExport =
      software.amazon.awssdk.services.redshiftserverless.model.LogExport.USERLOG
  }
  case object connectionlog extends zio.aws.redshiftserverless.model.LogExport {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.LogExport =
      software.amazon.awssdk.services.redshiftserverless.model.LogExport.CONNECTIONLOG
  }
}
