package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  ListSnapshotsRequestMaxResultsInteger,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSnapshotsRequest(
    endTime: Optional[Timestamp] = Optional.Absent,
    maxResults: Optional[ListSnapshotsRequestMaxResultsInteger] =
      Optional.Absent,
    namespaceArn: Optional[String] = Optional.Absent,
    namespaceName: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest = {
    import ListSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        maxResults.map(value =>
          ListSnapshotsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(namespaceArn.map(value => value: java.lang.String))(
        _.namespaceArn
      )
      .optionallyWith(namespaceName.map(value => value: java.lang.String))(
        _.namespaceName
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListSnapshotsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListSnapshotsRequest.wrap(buildAwsValue())
}
object ListSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListSnapshotsRequest =
      zio.aws.redshiftserverless.model.ListSnapshotsRequest(
        endTime.map(value => value),
        maxResults.map(value => value),
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        nextToken.map(value => value),
        ownerAccount.map(value => value),
        startTime.map(value => value)
      )
    def endTime: Optional[Timestamp]
    def maxResults: Optional[ListSnapshotsRequestMaxResultsInteger]
    def namespaceArn: Optional[String]
    def namespaceName: Optional[String]
    def nextToken: Optional[String]
    def ownerAccount: Optional[String]
    def startTime: Optional[Timestamp]
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults
        : ZIO[Any, AwsError, ListSnapshotsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest
  ) extends zio.aws.redshiftserverless.model.ListSnapshotsRequest.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
    override val maxResults: Optional[ListSnapshotsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListSnapshotsRequestMaxResultsInteger(value)
        )
    override val namespaceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => value: String)
    override val namespaceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest
  ): zio.aws.redshiftserverless.model.ListSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
