package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsResponse(
    nextToken: Optional[String] = Optional.Absent,
    recoveryPoints: Optional[
      Iterable[zio.aws.redshiftserverless.model.RecoveryPoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse = {
    import ListRecoveryPointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        recoveryPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recoveryPoints)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListRecoveryPointsResponse
      .wrap(buildAwsValue())
}
object ListRecoveryPointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ListRecoveryPointsResponse =
      zio.aws.redshiftserverless.model.ListRecoveryPointsResponse(
        nextToken.map(value => value),
        recoveryPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def recoveryPoints: Optional[
      List[zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecoveryPoints: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
    ]] = AwsError.unwrapOptionField("recoveryPoints", recoveryPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse
  ) extends zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val recoveryPoints: Optional[
      List[zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.RecoveryPoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse
  ): zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly =
    new Wrapper(impl)
}
