package zio.aws.redshiftserverless.model
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.ListNamespacesRequestMaxResultsInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNamespacesRequest(
    maxResults: Optional[ListNamespacesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest = {
    import ListNamespacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListNamespacesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListNamespacesRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListNamespacesRequest.wrap(buildAwsValue())
}
object ListNamespacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListNamespacesRequest =
      zio.aws.redshiftserverless.model.ListNamespacesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListNamespacesRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def getMaxResults
        : ZIO[Any, AwsError, ListNamespacesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest
  ) extends zio.aws.redshiftserverless.model.ListNamespacesRequest.ReadOnly {
    override val maxResults: Optional[ListNamespacesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListNamespacesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest
  ): zio.aws.redshiftserverless.model.ListNamespacesRequest.ReadOnly =
    new Wrapper(impl)
}
