package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  SubnetId,
  Integer,
  SyntheticTimestamp_date_time
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EndpointAccess(
    address: Optional[String] = Optional.Absent,
    endpointArn: Optional[String] = Optional.Absent,
    endpointCreateTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    endpointName: Optional[String] = Optional.Absent,
    endpointStatus: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    vpcEndpoint: Optional[zio.aws.redshiftserverless.model.VpcEndpoint] =
      Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.redshiftserverless.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    workgroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess = {
    import EndpointAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .optionallyWith(
        endpointCreateTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.endpointCreateTime)
      .optionallyWith(endpointName.map(value => value: java.lang.String))(
        _.endpointName
      )
      .optionallyWith(endpointStatus.map(value => value: java.lang.String))(
        _.endpointStatus
      )
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(workgroupName.map(value => value: java.lang.String))(
        _.workgroupName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly =
    zio.aws.redshiftserverless.model.EndpointAccess.wrap(buildAwsValue())
}
object EndpointAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.EndpointAccess =
      zio.aws.redshiftserverless.model.EndpointAccess(
        address.map(value => value),
        endpointArn.map(value => value),
        endpointCreateTime.map(value => value),
        endpointName.map(value => value),
        endpointStatus.map(value => value),
        port.map(value => value),
        subnetIds.map(value => value),
        vpcEndpoint.map(value => value.asEditable),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workgroupName.map(value => value)
      )
    def address: Optional[String]
    def endpointArn: Optional[String]
    def endpointCreateTime: Optional[SyntheticTimestamp_date_time]
    def endpointName: Optional[String]
    def endpointStatus: Optional[String]
    def port: Optional[Integer]
    def subnetIds: Optional[List[SubnetId]]
    def vpcEndpoint
        : Optional[zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly]
    def vpcSecurityGroups: Optional[
      List[zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def workgroupName: Optional[String]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getEndpointCreateTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("endpointCreateTime", endpointCreateTime)
    def getEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getEndpointStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointStatus", endpointStatus)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getWorkgroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess
  ) extends zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly {
    override val address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: String)
    override val endpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointArn())
      .map(value => value: String)
    override val endpointCreateTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointCreateTime())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val endpointName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => value: String)
    override val endpointStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointStatus())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcEndpoint
        : Optional[zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpoint())
        .map(value => zio.aws.redshiftserverless.model.VpcEndpoint.wrap(value))
    override val vpcSecurityGroups: Optional[
      List[zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val workgroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess
  ): zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly = new Wrapper(
    impl
  )
}
