package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteUsageLimitRequest(usageLimitId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest = {
    import DeleteUsageLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest
      .builder()
      .usageLimitId(usageLimitId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteUsageLimitRequest.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteUsageLimitRequest
      .wrap(buildAwsValue())
}
object DeleteUsageLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteUsageLimitRequest =
      zio.aws.redshiftserverless.model.DeleteUsageLimitRequest(usageLimitId)
    def usageLimitId: String
    def getUsageLimitId: ZIO[Any, Nothing, String] = ZIO.succeed(usageLimitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest
  ) extends zio.aws.redshiftserverless.model.DeleteUsageLimitRequest.ReadOnly {
    override val usageLimitId: String = impl.usageLimitId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest
  ): zio.aws.redshiftserverless.model.DeleteUsageLimitRequest.ReadOnly =
    new Wrapper(impl)
}
