package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteEndpointAccessResponse(
    endpoint: Optional[zio.aws.redshiftserverless.model.EndpointAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse = {
    import DeleteEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse
      .wrap(buildAwsValue())
}
object DeleteEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse =
      zio.aws.redshiftserverless.model
        .DeleteEndpointAccessResponse(endpoint.map(value => value.asEditable))
    def endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse
  ) extends zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly {
    override val endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value =>
          zio.aws.redshiftserverless.model.EndpointAccess.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse
  ): zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
