package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUsageLimitRequest(
    amount: Long,
    breachAction: Optional[
      zio.aws.redshiftserverless.model.UsageLimitBreachAction
    ] = Optional.Absent,
    period: Optional[zio.aws.redshiftserverless.model.UsageLimitPeriod] =
      Optional.Absent,
    resourceArn: String,
    usageType: zio.aws.redshiftserverless.model.UsageLimitUsageType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest = {
    import CreateUsageLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest
      .builder()
      .amount(amount: java.lang.Long)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .resourceArn(resourceArn: java.lang.String)
      .usageType(usageType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateUsageLimitRequest.ReadOnly =
    zio.aws.redshiftserverless.model.CreateUsageLimitRequest
      .wrap(buildAwsValue())
}
object CreateUsageLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateUsageLimitRequest =
      zio.aws.redshiftserverless.model.CreateUsageLimitRequest(
        amount,
        breachAction.map(value => value),
        period.map(value => value),
        resourceArn,
        usageType
      )
    def amount: Long
    def breachAction
        : Optional[zio.aws.redshiftserverless.model.UsageLimitBreachAction]
    def period: Optional[zio.aws.redshiftserverless.model.UsageLimitPeriod]
    def resourceArn: String
    def usageType: zio.aws.redshiftserverless.model.UsageLimitUsageType
    def getAmount: ZIO[Any, Nothing, Long] = ZIO.succeed(amount)
    def getBreachAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitBreachAction
    ] = AwsError.unwrapOptionField("breachAction", breachAction)
    def getPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitPeriod
    ] = AwsError.unwrapOptionField("period", period)
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getUsageType: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.UsageLimitUsageType
    ] = ZIO.succeed(usageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest
  ) extends zio.aws.redshiftserverless.model.CreateUsageLimitRequest.ReadOnly {
    override val amount: Long = impl.amount(): Long
    override val breachAction
        : Optional[zio.aws.redshiftserverless.model.UsageLimitBreachAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.breachAction())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitBreachAction.wrap(value)
        )
    override val period
        : Optional[zio.aws.redshiftserverless.model.UsageLimitPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitPeriod.wrap(value)
        )
    override val resourceArn: String = impl.resourceArn(): String
    override val usageType
        : zio.aws.redshiftserverless.model.UsageLimitUsageType =
      zio.aws.redshiftserverless.model.UsageLimitUsageType
        .wrap(impl.usageType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest
  ): zio.aws.redshiftserverless.model.CreateUsageLimitRequest.ReadOnly =
    new Wrapper(impl)
}
