package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNamespaceResponse(
    namespace: Optional[zio.aws.redshiftserverless.model.Namespace] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse = {
    import CreateNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse
      .builder()
      .optionallyWith(namespace.map(value => value.buildAwsValue()))(
        _.namespace
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly =
    zio.aws.redshiftserverless.model.CreateNamespaceResponse
      .wrap(buildAwsValue())
}
object CreateNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateNamespaceResponse =
      zio.aws.redshiftserverless.model
        .CreateNamespaceResponse(namespace.map(value => value.asEditable))
    def namespace: Optional[zio.aws.redshiftserverless.model.Namespace.ReadOnly]
    def getNamespace: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse
  ) extends zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly {
    override val namespace
        : Optional[zio.aws.redshiftserverless.model.Namespace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value => zio.aws.redshiftserverless.model.Namespace.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse
  ): zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
