package zio.aws.redshiftserverless.model
import scala.jdk.CollectionConverters._
sealed trait UsageLimitUsageType {
  def unwrap: software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType
}
object UsageLimitUsageType {
  def wrap(
      value: software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType
  ): zio.aws.redshiftserverless.model.UsageLimitUsageType = value match {
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType.SERVERLESS_COMPUTE =>
      val r = `serverless-compute`
      r
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType.CROSS_REGION_DATASHARING =>
      val r = `cross-region-datasharing`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftserverless.model.UsageLimitUsageType {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object `serverless-compute`
      extends zio.aws.redshiftserverless.model.UsageLimitUsageType {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType.SERVERLESS_COMPUTE
  }
  case object `cross-region-datasharing`
      extends zio.aws.redshiftserverless.model.UsageLimitUsageType {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType.CROSS_REGION_DATASHARING
  }
}
