package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateNamespaceResponse(
    namespace: zio.aws.redshiftserverless.model.Namespace
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse = {
    import UpdateNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse
      .builder()
      .namespace(namespace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateNamespaceResponse
      .wrap(buildAwsValue())
}
object UpdateNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UpdateNamespaceResponse =
      zio.aws.redshiftserverless.model
        .UpdateNamespaceResponse(namespace.asEditable)
    def namespace: zio.aws.redshiftserverless.model.Namespace.ReadOnly
    def getNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = ZIO.succeed(namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse
  ) extends zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly {
    override val namespace
        : zio.aws.redshiftserverless.model.Namespace.ReadOnly =
      zio.aws.redshiftserverless.model.Namespace.wrap(impl.namespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse
  ): zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
