package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Iterable[zio.aws.redshiftserverless.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.TagResourceRequest.ReadOnly =
    zio.aws.redshiftserverless.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.TagResourceRequest =
      zio.aws.redshiftserverless.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AmazonResourceName
    def tags: List[zio.aws.redshiftserverless.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.redshiftserverless.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest
  ) extends zio.aws.redshiftserverless.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.redshiftserverless.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tags: List[zio.aws.redshiftserverless.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.redshiftserverless.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest
  ): zio.aws.redshiftserverless.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
