package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSnapshotRequest(
    ownerAccount: Optional[String] = Optional.Absent,
    snapshotArn: Optional[String] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest = {
    import GetSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest
      .builder()
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(snapshotArn.map(value => value: java.lang.String))(
        _.snapshotArn
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.GetSnapshotRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetSnapshotRequest.wrap(buildAwsValue())
}
object GetSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetSnapshotRequest =
      zio.aws.redshiftserverless.model.GetSnapshotRequest(
        ownerAccount.map(value => value),
        snapshotArn.map(value => value),
        snapshotName.map(value => value)
      )
    def ownerAccount: Optional[String]
    def snapshotArn: Optional[String]
    def snapshotName: Optional[String]
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotArn", snapshotArn)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest
  ) extends zio.aws.redshiftserverless.model.GetSnapshotRequest.ReadOnly {
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val snapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArn())
      .map(value => value: String)
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest
  ): zio.aws.redshiftserverless.model.GetSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
