package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    resourcePolicy: Optional[zio.aws.redshiftserverless.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(resourcePolicy.map(value => value.buildAwsValue()))(
        _.resourcePolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetResourcePolicyResponse
      .wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetResourcePolicyResponse =
      zio.aws.redshiftserverless.model.GetResourcePolicyResponse(
        resourcePolicy.map(value => value.asEditable)
      )
    def resourcePolicy
        : Optional[zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly]
    def getResourcePolicy: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse
  ) extends zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly {
    override val resourcePolicy
        : Optional[zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value =>
          zio.aws.redshiftserverless.model.ResourcePolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse
  ): zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
