package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetNamespaceResponse(
    namespace: zio.aws.redshiftserverless.model.Namespace
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse = {
    import GetNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse
      .builder()
      .namespace(namespace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetNamespaceResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetNamespaceResponse.wrap(buildAwsValue())
}
object GetNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetNamespaceResponse =
      zio.aws.redshiftserverless.model
        .GetNamespaceResponse(namespace.asEditable)
    def namespace: zio.aws.redshiftserverless.model.Namespace.ReadOnly
    def getNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = ZIO.succeed(namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse
  ) extends zio.aws.redshiftserverless.model.GetNamespaceResponse.ReadOnly {
    override val namespace
        : zio.aws.redshiftserverless.model.Namespace.ReadOnly =
      zio.aws.redshiftserverless.model.Namespace.wrap(impl.namespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse
  ): zio.aws.redshiftserverless.model.GetNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
