package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.redshiftserverless.model.CreateSnapshotResponse
      .wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateSnapshotResponse =
      zio.aws.redshiftserverless.model
        .CreateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Snapshot.ReadOnly
    ] = AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse
  ) extends zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly {
    override val snapshot
        : Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.redshiftserverless.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse
  ): zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
