package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.VpcSecurityGroupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcSecurityGroupMembership(
    status: Optional[String] = Optional.Absent,
    vpcSecurityGroupId: Optional[VpcSecurityGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembership = {
    import VpcSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembership
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        vpcSecurityGroupId.map(value =>
          VpcSecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.vpcSecurityGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.ReadOnly =
    zio.aws.redshiftserverless.model.VpcSecurityGroupMembership
      .wrap(buildAwsValue())
}
object VpcSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.VpcSecurityGroupMembership =
      zio.aws.redshiftserverless.model.VpcSecurityGroupMembership(
        status.map(value => value),
        vpcSecurityGroupId.map(value => value)
      )
    def status: Optional[String]
    def vpcSecurityGroupId: Optional[VpcSecurityGroupId]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getVpcSecurityGroupId: ZIO[Any, AwsError, VpcSecurityGroupId] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembership
  ) extends zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val vpcSecurityGroupId: Optional[VpcSecurityGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupId())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.VpcSecurityGroupId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembership
  ): zio.aws.redshiftserverless.model.VpcSecurityGroupMembership.ReadOnly =
    new Wrapper(impl)
}
