package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUsageLimitRequest(
    amount: Optional[Long] = Optional.Absent,
    breachAction: Optional[
      zio.aws.redshiftserverless.model.UsageLimitBreachAction
    ] = Optional.Absent,
    usageLimitId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest = {
    import UpdateUsageLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Long))(_.amount)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .usageLimitId(usageLimitId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateUsageLimitRequest.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateUsageLimitRequest
      .wrap(buildAwsValue())
}
object UpdateUsageLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UpdateUsageLimitRequest =
      zio.aws.redshiftserverless.model.UpdateUsageLimitRequest(
        amount.map(value => value),
        breachAction.map(value => value),
        usageLimitId
      )
    def amount: Optional[Long]
    def breachAction
        : Optional[zio.aws.redshiftserverless.model.UsageLimitBreachAction]
    def usageLimitId: String
    def getAmount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amount", amount)
    def getBreachAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitBreachAction
    ] = AwsError.unwrapOptionField("breachAction", breachAction)
    def getUsageLimitId: ZIO[Any, Nothing, String] = ZIO.succeed(usageLimitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest
  ) extends zio.aws.redshiftserverless.model.UpdateUsageLimitRequest.ReadOnly {
    override val amount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: Long)
    override val breachAction
        : Optional[zio.aws.redshiftserverless.model.UsageLimitBreachAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.breachAction())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitBreachAction.wrap(value)
        )
    override val usageLimitId: String = impl.usageLimitId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest
  ): zio.aws.redshiftserverless.model.UpdateUsageLimitRequest.ReadOnly =
    new Wrapper(impl)
}
