package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSnapshotResponse(
    snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse = {
    import UpdateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateSnapshotResponse
      .wrap(buildAwsValue())
}
object UpdateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UpdateSnapshotResponse =
      zio.aws.redshiftserverless.model
        .UpdateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Snapshot.ReadOnly
    ] = AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse
  ) extends zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly {
    override val snapshot
        : Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.redshiftserverless.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse
  ): zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
