package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSnapshotRequest(
    retentionPeriod: Optional[Integer] = Optional.Absent,
    snapshotName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest = {
    import UpdateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest
      .builder()
      .optionallyWith(retentionPeriod.map(value => value: java.lang.Integer))(
        _.retentionPeriod
      )
      .snapshotName(snapshotName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateSnapshotRequest.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateSnapshotRequest.wrap(buildAwsValue())
}
object UpdateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UpdateSnapshotRequest =
      zio.aws.redshiftserverless.model.UpdateSnapshotRequest(
        retentionPeriod.map(value => value),
        snapshotName
      )
    def retentionPeriod: Optional[Integer]
    def snapshotName: String
    def getRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest
  ) extends zio.aws.redshiftserverless.model.UpdateSnapshotRequest.ReadOnly {
    override val retentionPeriod: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPeriod())
      .map(value => value: Integer)
    override val snapshotName: String = impl.snapshotName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest
  ): zio.aws.redshiftserverless.model.UpdateSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
