package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEndpointAccessResponse(
    endpoint: Optional[zio.aws.redshiftserverless.model.EndpointAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse = {
    import UpdateEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse
      .wrap(buildAwsValue())
}
object UpdateEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse =
      zio.aws.redshiftserverless.model
        .UpdateEndpointAccessResponse(endpoint.map(value => value.asEditable))
    def endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse
  ) extends zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly {
    override val endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value =>
          zio.aws.redshiftserverless.model.EndpointAccess.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse
  ): zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
