package zio.aws.redshiftserverless.model
import scala.jdk.CollectionConverters._
sealed trait SnapshotStatus {
  def unwrap
      : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus
}
object SnapshotStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus
  ): zio.aws.redshiftserverless.model.SnapshotStatus = value match {
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.COPYING =>
      val r = COPYING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE
      extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.AVAILABLE
  }
  case object CREATING extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.CREATING
  }
  case object DELETED extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.DELETED
  }
  case object CANCELLED
      extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.CANCELLED
  }
  case object FAILED extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.FAILED
  }
  case object COPYING extends zio.aws.redshiftserverless.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus =
      software.amazon.awssdk.services.redshiftserverless.model.SnapshotStatus.COPYING
  }
}
