package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreTableFromSnapshotResponse(
    tableRestoreStatus: Optional[
      zio.aws.redshiftserverless.model.TableRestoreStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse = {
    import RestoreTableFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse
      .builder()
      .optionallyWith(tableRestoreStatus.map(value => value.buildAwsValue()))(
        _.tableRestoreStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly =
    zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreTableFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse =
      zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse(
        tableRestoreStatus.map(value => value.asEditable)
      )
    def tableRestoreStatus
        : Optional[zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly]
    def getTableRestoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("tableRestoreStatus", tableRestoreStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse
  ) extends zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly {
    override val tableRestoreStatus: Optional[
      zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tableRestoreStatus())
      .map(value =>
        zio.aws.redshiftserverless.model.TableRestoreStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse
  ): zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
