package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreFromRecoveryPointResponse(
    namespace: Optional[zio.aws.redshiftserverless.model.Namespace] =
      Optional.Absent,
    recoveryPointId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse = {
    import RestoreFromRecoveryPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse
      .builder()
      .optionallyWith(namespace.map(value => value.buildAwsValue()))(
        _.namespace
      )
      .optionallyWith(recoveryPointId.map(value => value: java.lang.String))(
        _.recoveryPointId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly =
    zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse
      .wrap(buildAwsValue())
}
object RestoreFromRecoveryPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse =
      zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse(
        namespace.map(value => value.asEditable),
        recoveryPointId.map(value => value)
      )
    def namespace: Optional[zio.aws.redshiftserverless.model.Namespace.ReadOnly]
    def recoveryPointId: Optional[String]
    def getNamespace: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = AwsError.unwrapOptionField("namespace", namespace)
    def getRecoveryPointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recoveryPointId", recoveryPointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse
  ) extends zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly {
    override val namespace
        : Optional[zio.aws.redshiftserverless.model.Namespace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value => zio.aws.redshiftserverless.model.Namespace.wrap(value))
    override val recoveryPointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse
  ): zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly =
    new Wrapper(impl)
}
