package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWorkgroupResponse(
    workgroup: zio.aws.redshiftserverless.model.Workgroup
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse = {
    import GetWorkgroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse
      .builder()
      .workgroup(workgroup.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetWorkgroupResponse.wrap(buildAwsValue())
}
object GetWorkgroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetWorkgroupResponse =
      zio.aws.redshiftserverless.model
        .GetWorkgroupResponse(workgroup.asEditable)
    def workgroup: zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    def getWorkgroup: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    ] = ZIO.succeed(workgroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse
  ) extends zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly {
    override val workgroup
        : zio.aws.redshiftserverless.model.Workgroup.ReadOnly =
      zio.aws.redshiftserverless.model.Workgroup.wrap(impl.workgroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse
  ): zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly =
    new Wrapper(impl)
}
