package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRecoveryPointResponse(
    recoveryPoint: Optional[zio.aws.redshiftserverless.model.RecoveryPoint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse = {
    import GetRecoveryPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse
      .builder()
      .optionallyWith(recoveryPoint.map(value => value.buildAwsValue()))(
        _.recoveryPoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetRecoveryPointResponse
      .wrap(buildAwsValue())
}
object GetRecoveryPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetRecoveryPointResponse =
      zio.aws.redshiftserverless.model
        .GetRecoveryPointResponse(recoveryPoint.map(value => value.asEditable))
    def recoveryPoint
        : Optional[zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly]
    def getRecoveryPoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
    ] = AwsError.unwrapOptionField("recoveryPoint", recoveryPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse
  ) extends zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly {
    override val recoveryPoint
        : Optional[zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPoint())
        .map(value =>
          zio.aws.redshiftserverless.model.RecoveryPoint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse
  ): zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly =
    new Wrapper(impl)
}
