package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.WorkgroupName
import scala.jdk.CollectionConverters._
final case class DeleteWorkgroupRequest(workgroupName: WorkgroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest = {
    import DeleteWorkgroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest
      .builder()
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteWorkgroupRequest.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteWorkgroupRequest
      .wrap(buildAwsValue())
}
object DeleteWorkgroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteWorkgroupRequest =
      zio.aws.redshiftserverless.model.DeleteWorkgroupRequest(workgroupName)
    def workgroupName: WorkgroupName
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest
  ) extends zio.aws.redshiftserverless.model.DeleteWorkgroupRequest.ReadOnly {
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest
  ): zio.aws.redshiftserverless.model.DeleteWorkgroupRequest.ReadOnly =
    new Wrapper(impl)
}
