package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSnapshotResponse(
    snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse = {
    import DeleteSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteSnapshotResponse
      .wrap(buildAwsValue())
}
object DeleteSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteSnapshotResponse =
      zio.aws.redshiftserverless.model
        .DeleteSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Snapshot.ReadOnly
    ] = AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse
  ) extends zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly {
    override val snapshot
        : Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.redshiftserverless.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse
  ): zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
