package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConvertRecoveryPointToSnapshotResponse(
    snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse = {
    import ConvertRecoveryPointToSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
      .wrap(buildAwsValue())
}
object ConvertRecoveryPointToSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse =
      zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse(
        snapshot.map(value => value.asEditable)
      )
    def snapshot: Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Snapshot.ReadOnly
    ] = AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
  ) extends zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly {
    override val snapshot
        : Optional[zio.aws.redshiftserverless.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.redshiftserverless.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
  ): zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
