package zio.aws.redshiftserverless
import zio.aws.redshiftserverless.model.GetNamespaceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.redshiftserverless.model.{
  CreateEndpointAccessResponse,
  CreateUsageLimitResponse,
  UpdateUsageLimitRequest,
  GetResourcePolicyResponse,
  GetRecoveryPointRequest,
  RestoreFromRecoveryPointResponse,
  PutResourcePolicyResponse,
  GetCredentialsRequest,
  TableRestoreStatus,
  GetEndpointAccessResponse,
  DeleteSnapshotRequest,
  GetRecoveryPointResponse,
  GetCredentialsResponse,
  RecoveryPoint,
  ListSnapshotsRequest,
  ListNamespacesRequest,
  RestoreFromSnapshotRequest,
  CreateNamespaceResponse,
  UpdateSnapshotRequest,
  PutResourcePolicyRequest,
  CreateNamespaceRequest,
  Namespace,
  UpdateEndpointAccessRequest,
  CreateWorkgroupRequest,
  ListTableRestoreStatusResponse,
  ListNamespacesResponse,
  GetWorkgroupResponse,
  ListTagsForResourceRequest,
  DeleteNamespaceRequest,
  Workgroup,
  DeleteUsageLimitResponse,
  RestoreTableFromSnapshotRequest,
  GetSnapshotResponse,
  UsageLimit,
  UpdateEndpointAccessResponse,
  RestoreTableFromSnapshotResponse,
  ListUsageLimitsResponse,
  UpdateWorkgroupRequest,
  Snapshot,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  RestoreFromRecoveryPointRequest,
  UpdateSnapshotResponse,
  GetWorkgroupRequest,
  DeleteUsageLimitRequest,
  UpdateWorkgroupResponse,
  ListEndpointAccessRequest,
  CreateUsageLimitRequest,
  EndpointAccess,
  GetTableRestoreStatusResponse,
  ListWorkgroupsRequest,
  RestoreFromSnapshotResponse,
  ConvertRecoveryPointToSnapshotResponse,
  DeleteWorkgroupResponse,
  ListTableRestoreStatusRequest,
  ListSnapshotsResponse,
  GetUsageLimitResponse,
  UpdateUsageLimitResponse,
  DeleteResourcePolicyRequest,
  ListUsageLimitsRequest,
  UntagResourceRequest,
  GetTableRestoreStatusRequest,
  ListRecoveryPointsRequest,
  GetEndpointAccessRequest,
  DeleteNamespaceResponse,
  CreateSnapshotRequest,
  ListWorkgroupsResponse,
  ListRecoveryPointsResponse,
  DeleteWorkgroupRequest,
  GetSnapshotRequest,
  GetResourcePolicyRequest,
  ListEndpointAccessResponse,
  DeleteEndpointAccessResponse,
  DeleteResourcePolicyResponse,
  CreateEndpointAccessRequest,
  TagResourceResponse,
  CreateWorkgroupResponse,
  GetNamespaceResponse,
  GetUsageLimitRequest,
  CreateSnapshotResponse,
  UpdateNamespaceResponse,
  UpdateNamespaceRequest,
  DeleteSnapshotResponse,
  TagResourceRequest,
  ConvertRecoveryPointToSnapshotRequest,
  GetNamespaceRequest,
  DeleteEndpointAccessRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.redshiftserverless.{
  RedshiftServerlessAsyncClientBuilder,
  RedshiftServerlessAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.redshiftserverless.paginators.{
  ListUsageLimitsPublisher,
  ListRecoveryPointsPublisher,
  ListTableRestoreStatusPublisher,
  ListNamespacesPublisher,
  ListSnapshotsPublisher,
  ListWorkgroupsPublisher,
  ListEndpointAccessPublisher
}
import scala.jdk.CollectionConverters._
trait RedshiftServerless extends AspectSupport[RedshiftServerless] {
  val api: RedshiftServerlessAsyncClient
  def restoreTableFromSnapshot(
      request: zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly
  ]
  def listTableRestoreStatus(
      request: zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
  ]
  def listTableRestoreStatusPaginated(
      request: zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly
  ]
  def updateNamespace(
      request: zio.aws.redshiftserverless.model.UpdateNamespaceRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly
  ]
  def createWorkgroup(
      request: zio.aws.redshiftserverless.model.CreateWorkgroupRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly
  ]
  def deleteWorkgroup(
      request: zio.aws.redshiftserverless.model.DeleteWorkgroupRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly
  ]
  def listEndpointAccess(
      request: zio.aws.redshiftserverless.model.ListEndpointAccessRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
  ]
  def listEndpointAccessPaginated(
      request: zio.aws.redshiftserverless.model.ListEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly
  ]
  def getNamespace(
      request: zio.aws.redshiftserverless.model.GetNamespaceRequest
  ): IO[AwsError, ReadOnly]
  def getWorkgroup(
      request: zio.aws.redshiftserverless.model.GetWorkgroupRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly
  ]
  def getSnapshot(
      request: zio.aws.redshiftserverless.model.GetSnapshotRequest
  ): IO[AwsError, zio.aws.redshiftserverless.model.GetSnapshotResponse.ReadOnly]
  def getUsageLimit(
      request: zio.aws.redshiftserverless.model.GetUsageLimitRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetUsageLimitResponse.ReadOnly
  ]
  def putResourcePolicy(
      request: zio.aws.redshiftserverless.model.PutResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly
  ]
  def deleteUsageLimit(
      request: zio.aws.redshiftserverless.model.DeleteUsageLimitRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly
  ]
  def deleteEndpointAccess(
      request: zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly
  ]
  def listRecoveryPoints(
      request: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
  ]
  def listRecoveryPointsPaginated(
      request: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly
  ]
  def getRecoveryPoint(
      request: zio.aws.redshiftserverless.model.GetRecoveryPointRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly
  ]
  def getCredentials(
      request: zio.aws.redshiftserverless.model.GetCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly
  ]
  def createEndpointAccess(
      request: zio.aws.redshiftserverless.model.CreateEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly
  ]
  def deleteSnapshot(
      request: zio.aws.redshiftserverless.model.DeleteSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly
  ]
  def listNamespaces(
      request: zio.aws.redshiftserverless.model.ListNamespacesRequest
  ): ZStream[Any, AwsError, zio.aws.redshiftserverless.model.Namespace.ReadOnly]
  def listNamespacesPaginated(
      request: zio.aws.redshiftserverless.model.ListNamespacesRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly
  ]
  def getEndpointAccess(
      request: zio.aws.redshiftserverless.model.GetEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly
  ]
  def createNamespace(
      request: zio.aws.redshiftserverless.model.CreateNamespaceRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly
  ]
  def updateSnapshot(
      request: zio.aws.redshiftserverless.model.UpdateSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.redshiftserverless.model.UntagResourceRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.UntagResourceResponse.ReadOnly
  ]
  def listUsageLimits(
      request: zio.aws.redshiftserverless.model.ListUsageLimitsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
  ]
  def listUsageLimitsPaginated(
      request: zio.aws.redshiftserverless.model.ListUsageLimitsRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly
  ]
  def updateWorkgroup(
      request: zio.aws.redshiftserverless.model.UpdateWorkgroupRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly
  ]
  def deleteResourcePolicy(
      request: zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def listWorkgroups(
      request: zio.aws.redshiftserverless.model.ListWorkgroupsRequest
  ): ZStream[Any, AwsError, zio.aws.redshiftserverless.model.Workgroup.ReadOnly]
  def listWorkgroupsPaginated(
      request: zio.aws.redshiftserverless.model.ListWorkgroupsRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.redshiftserverless.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListTagsForResourceResponse.ReadOnly
  ]
  def updateUsageLimit(
      request: zio.aws.redshiftserverless.model.UpdateUsageLimitRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly
  ]
  def createUsageLimit(
      request: zio.aws.redshiftserverless.model.CreateUsageLimitRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.redshiftserverless.model.TagResourceRequest
  ): IO[AwsError, zio.aws.redshiftserverless.model.TagResourceResponse.ReadOnly]
  def getTableRestoreStatus(
      request: zio.aws.redshiftserverless.model.GetTableRestoreStatusRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly
  ]
  def listSnapshots(
      request: zio.aws.redshiftserverless.model.ListSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.redshiftserverless.model.Snapshot.ReadOnly]
  def listSnapshotsPaginated(
      request: zio.aws.redshiftserverless.model.ListSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly
  ]
  def updateEndpointAccess(
      request: zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly
  ]
  def restoreFromSnapshot(
      request: zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly
  ]
  def deleteNamespace(
      request: zio.aws.redshiftserverless.model.DeleteNamespaceRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly
  ]
  def getResourcePolicy(
      request: zio.aws.redshiftserverless.model.GetResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly
  ]
  def restoreFromRecoveryPoint(
      request: zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly
  ]
  def convertRecoveryPointToSnapshot(
      request: zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly
  ]
  def createSnapshot(
      request: zio.aws.redshiftserverless.model.CreateSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly
  ]
}
object RedshiftServerless {
  val live: ZLayer[AwsConfig, java.lang.Throwable, RedshiftServerless] =
    customized(identity)
  def customized(
      customization: RedshiftServerlessAsyncClientBuilder => RedshiftServerlessAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, RedshiftServerless] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RedshiftServerlessAsyncClientBuilder => RedshiftServerlessAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, RedshiftServerless] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RedshiftServerlessAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      RedshiftServerlessAsyncClient,
      RedshiftServerlessAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      RedshiftServerlessAsyncClient,
      RedshiftServerlessAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new RedshiftServerlessImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class RedshiftServerlessImpl[R](
      override val api: RedshiftServerlessAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends RedshiftServerless
      with AwsServiceBase[R] {
    override val serviceName: String = "RedshiftServerless"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RedshiftServerlessImpl[R1] =
      new RedshiftServerlessImpl(api, newAspect, r)
    def restoreTableFromSnapshot(
        request: zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreTableFromSnapshotRequest,
      RestoreTableFromSnapshotResponse
    ]("restoreTableFromSnapshot", api.restoreTableFromSnapshot)(
      request.buildAwsValue()
    ).map(
      zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.wrap
    ).provideEnvironment(r)
    def listTableRestoreStatus(
        request: zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListTableRestoreStatusRequest,
      TableRestoreStatus,
      ListTableRestoreStatusPublisher
    ](
      "listTableRestoreStatus",
      api.listTableRestoreStatusPaginator,
      _.tableRestoreStatuses()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.redshiftserverless.model.TableRestoreStatus.wrap(item)
      )
      .provideEnvironment(r)
    def listTableRestoreStatusPaginated(
        request: zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTableRestoreStatusRequest,
      ListTableRestoreStatusResponse
    ]("listTableRestoreStatus", api.listTableRestoreStatus)(
      request.buildAwsValue()
    ).map(zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.wrap)
      .provideEnvironment(r)
    def updateNamespace(
        request: zio.aws.redshiftserverless.model.UpdateNamespaceRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[UpdateNamespaceRequest, UpdateNamespaceResponse](
      "updateNamespace",
      api.updateNamespace
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.UpdateNamespaceResponse.wrap)
      .provideEnvironment(r)
    def createWorkgroup(
        request: zio.aws.redshiftserverless.model.CreateWorkgroupRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly
    ] = asyncRequestResponse[CreateWorkgroupRequest, CreateWorkgroupResponse](
      "createWorkgroup",
      api.createWorkgroup
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.CreateWorkgroupResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkgroup(
        request: zio.aws.redshiftserverless.model.DeleteWorkgroupRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly
    ] = asyncRequestResponse[DeleteWorkgroupRequest, DeleteWorkgroupResponse](
      "deleteWorkgroup",
      api.deleteWorkgroup
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.wrap)
      .provideEnvironment(r)
    def listEndpointAccess(
        request: zio.aws.redshiftserverless.model.ListEndpointAccessRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListEndpointAccessRequest,
      EndpointAccess,
      ListEndpointAccessPublisher
    ]("listEndpointAccess", api.listEndpointAccessPaginator, _.endpoints())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshiftserverless.model.EndpointAccess.wrap(item))
      .provideEnvironment(r)
    def listEndpointAccessPaginated(
        request: zio.aws.redshiftserverless.model.ListEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      ListEndpointAccessRequest,
      ListEndpointAccessResponse
    ]("listEndpointAccess", api.listEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def getNamespace(
        request: zio.aws.redshiftserverless.model.GetNamespaceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetNamespaceRequest, GetNamespaceResponse](
        "getNamespace",
        api.getNamespace
      )(request.buildAwsValue())
        .map(zio.aws.redshiftserverless.model.GetNamespaceResponse.wrap)
        .provideEnvironment(r)
    def getWorkgroup(
        request: zio.aws.redshiftserverless.model.GetWorkgroupRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly
    ] = asyncRequestResponse[GetWorkgroupRequest, GetWorkgroupResponse](
      "getWorkgroup",
      api.getWorkgroup
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.GetWorkgroupResponse.wrap)
      .provideEnvironment(r)
    def getSnapshot(
        request: zio.aws.redshiftserverless.model.GetSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[GetSnapshotRequest, GetSnapshotResponse](
      "getSnapshot",
      api.getSnapshot
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.GetSnapshotResponse.wrap)
      .provideEnvironment(r)
    def getUsageLimit(
        request: zio.aws.redshiftserverless.model.GetUsageLimitRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetUsageLimitResponse.ReadOnly
    ] = asyncRequestResponse[GetUsageLimitRequest, GetUsageLimitResponse](
      "getUsageLimit",
      api.getUsageLimit
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.GetUsageLimitResponse.wrap)
      .provideEnvironment(r)
    def putResourcePolicy(
        request: zio.aws.redshiftserverless.model.PutResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[PutResourcePolicyRequest, PutResourcePolicyResponse](
        "putResourcePolicy",
        api.putResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.redshiftserverless.model.PutResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteUsageLimit(
        request: zio.aws.redshiftserverless.model.DeleteUsageLimitRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly
    ] = asyncRequestResponse[DeleteUsageLimitRequest, DeleteUsageLimitResponse](
      "deleteUsageLimit",
      api.deleteUsageLimit
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.wrap)
      .provideEnvironment(r)
    def deleteEndpointAccess(
        request: zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEndpointAccessRequest,
      DeleteEndpointAccessResponse
    ]("deleteEndpointAccess", api.deleteEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def listRecoveryPoints(
        request: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRecoveryPointsRequest,
      RecoveryPoint,
      ListRecoveryPointsPublisher
    ](
      "listRecoveryPoints",
      api.listRecoveryPointsPaginator,
      _.recoveryPoints()
    )(request.buildAwsValue())
      .map(item => zio.aws.redshiftserverless.model.RecoveryPoint.wrap(item))
      .provideEnvironment(r)
    def listRecoveryPointsPaginated(
        request: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRecoveryPointsRequest,
      ListRecoveryPointsResponse
    ]("listRecoveryPoints", api.listRecoveryPoints)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.wrap)
      .provideEnvironment(r)
    def getRecoveryPoint(
        request: zio.aws.redshiftserverless.model.GetRecoveryPointRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly
    ] = asyncRequestResponse[GetRecoveryPointRequest, GetRecoveryPointResponse](
      "getRecoveryPoint",
      api.getRecoveryPoint
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.GetRecoveryPointResponse.wrap)
      .provideEnvironment(r)
    def getCredentials(
        request: zio.aws.redshiftserverless.model.GetCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[GetCredentialsRequest, GetCredentialsResponse](
      "getCredentials",
      api.getCredentials
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.GetCredentialsResponse.wrap)
      .provideEnvironment(r)
    def createEndpointAccess(
        request: zio.aws.redshiftserverless.model.CreateEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEndpointAccessRequest,
      CreateEndpointAccessResponse
    ]("createEndpointAccess", api.createEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def deleteSnapshot(
        request: zio.aws.redshiftserverless.model.DeleteSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[DeleteSnapshotRequest, DeleteSnapshotResponse](
      "deleteSnapshot",
      api.deleteSnapshot
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.DeleteSnapshotResponse.wrap)
      .provideEnvironment(r)
    def listNamespaces(
        request: zio.aws.redshiftserverless.model.ListNamespacesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Namespace.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListNamespacesRequest,
      Namespace,
      ListNamespacesPublisher
    ]("listNamespaces", api.listNamespacesPaginator, _.namespaces())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshiftserverless.model.Namespace.wrap(item))
      .provideEnvironment(r)
    def listNamespacesPaginated(
        request: zio.aws.redshiftserverless.model.ListNamespacesRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly
    ] = asyncRequestResponse[ListNamespacesRequest, ListNamespacesResponse](
      "listNamespaces",
      api.listNamespaces
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListNamespacesResponse.wrap)
      .provideEnvironment(r)
    def getEndpointAccess(
        request: zio.aws.redshiftserverless.model.GetEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly
    ] =
      asyncRequestResponse[GetEndpointAccessRequest, GetEndpointAccessResponse](
        "getEndpointAccess",
        api.getEndpointAccess
      )(request.buildAwsValue())
        .map(zio.aws.redshiftserverless.model.GetEndpointAccessResponse.wrap)
        .provideEnvironment(r)
    def createNamespace(
        request: zio.aws.redshiftserverless.model.CreateNamespaceRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[CreateNamespaceRequest, CreateNamespaceResponse](
      "createNamespace",
      api.createNamespace
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.CreateNamespaceResponse.wrap)
      .provideEnvironment(r)
    def updateSnapshot(
        request: zio.aws.redshiftserverless.model.UpdateSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[UpdateSnapshotRequest, UpdateSnapshotResponse](
      "updateSnapshot",
      api.updateSnapshot
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.UpdateSnapshotResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.redshiftserverless.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listUsageLimits(
        request: zio.aws.redshiftserverless.model.ListUsageLimitsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListUsageLimitsRequest,
      UsageLimit,
      ListUsageLimitsPublisher
    ]("listUsageLimits", api.listUsageLimitsPaginator, _.usageLimits())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshiftserverless.model.UsageLimit.wrap(item))
      .provideEnvironment(r)
    def listUsageLimitsPaginated(
        request: zio.aws.redshiftserverless.model.ListUsageLimitsRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly
    ] = asyncRequestResponse[ListUsageLimitsRequest, ListUsageLimitsResponse](
      "listUsageLimits",
      api.listUsageLimits
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListUsageLimitsResponse.wrap)
      .provideEnvironment(r)
    def updateWorkgroup(
        request: zio.aws.redshiftserverless.model.UpdateWorkgroupRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly
    ] = asyncRequestResponse[UpdateWorkgroupRequest, UpdateWorkgroupResponse](
      "updateWorkgroup",
      api.updateWorkgroup
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(
        request: zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def listWorkgroups(
        request: zio.aws.redshiftserverless.model.ListWorkgroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListWorkgroupsRequest,
      Workgroup,
      ListWorkgroupsPublisher
    ]("listWorkgroups", api.listWorkgroupsPaginator, _.workgroups())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshiftserverless.model.Workgroup.wrap(item))
      .provideEnvironment(r)
    def listWorkgroupsPaginated(
        request: zio.aws.redshiftserverless.model.ListWorkgroupsRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly
    ] = asyncRequestResponse[ListWorkgroupsRequest, ListWorkgroupsResponse](
      "listWorkgroups",
      api.listWorkgroups
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListWorkgroupsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.redshiftserverless.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateUsageLimit(
        request: zio.aws.redshiftserverless.model.UpdateUsageLimitRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly
    ] = asyncRequestResponse[UpdateUsageLimitRequest, UpdateUsageLimitResponse](
      "updateUsageLimit",
      api.updateUsageLimit
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.wrap)
      .provideEnvironment(r)
    def createUsageLimit(
        request: zio.aws.redshiftserverless.model.CreateUsageLimitRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly
    ] = asyncRequestResponse[CreateUsageLimitRequest, CreateUsageLimitResponse](
      "createUsageLimit",
      api.createUsageLimit
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.CreateUsageLimitResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.redshiftserverless.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def getTableRestoreStatus(
        request: zio.aws.redshiftserverless.model.GetTableRestoreStatusRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTableRestoreStatusRequest,
      GetTableRestoreStatusResponse
    ]("getTableRestoreStatus", api.getTableRestoreStatus)(
      request.buildAwsValue()
    ).map(zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.wrap)
      .provideEnvironment(r)
    def listSnapshots(
        request: zio.aws.redshiftserverless.model.ListSnapshotsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Snapshot.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSnapshotsRequest,
      Snapshot,
      ListSnapshotsPublisher
    ]("listSnapshots", api.listSnapshotsPaginator, _.snapshots())(
      request.buildAwsValue()
    ).map(item => zio.aws.redshiftserverless.model.Snapshot.wrap(item))
      .provideEnvironment(r)
    def listSnapshotsPaginated(
        request: zio.aws.redshiftserverless.model.ListSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[ListSnapshotsRequest, ListSnapshotsResponse](
      "listSnapshots",
      api.listSnapshots
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.ListSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def updateEndpointAccess(
        request: zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateEndpointAccessRequest,
      UpdateEndpointAccessResponse
    ]("updateEndpointAccess", api.updateEndpointAccess)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.wrap)
      .provideEnvironment(r)
    def restoreFromSnapshot(
        request: zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreFromSnapshotRequest,
      RestoreFromSnapshotResponse
    ]("restoreFromSnapshot", api.restoreFromSnapshot)(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteNamespace(
        request: zio.aws.redshiftserverless.model.DeleteNamespaceRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly
    ] = asyncRequestResponse[DeleteNamespaceRequest, DeleteNamespaceResponse](
      "deleteNamespace",
      api.deleteNamespace
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.DeleteNamespaceResponse.wrap)
      .provideEnvironment(r)
    def getResourcePolicy(
        request: zio.aws.redshiftserverless.model.GetResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[GetResourcePolicyRequest, GetResourcePolicyResponse](
        "getResourcePolicy",
        api.getResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.redshiftserverless.model.GetResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def restoreFromRecoveryPoint(
        request: zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreFromRecoveryPointRequest,
      RestoreFromRecoveryPointResponse
    ]("restoreFromRecoveryPoint", api.restoreFromRecoveryPoint)(
      request.buildAwsValue()
    ).map(
      zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.wrap
    ).provideEnvironment(r)
    def convertRecoveryPointToSnapshot(
        request: zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      ConvertRecoveryPointToSnapshotRequest,
      ConvertRecoveryPointToSnapshotResponse
    ]("convertRecoveryPointToSnapshot", api.convertRecoveryPointToSnapshot)(
      request.buildAwsValue()
    ).map(
      zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.wrap
    ).provideEnvironment(r)
    def createSnapshot(
        request: zio.aws.redshiftserverless.model.CreateSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[CreateSnapshotRequest, CreateSnapshotResponse](
      "createSnapshot",
      api.createSnapshot
    )(request.buildAwsValue())
      .map(zio.aws.redshiftserverless.model.CreateSnapshotResponse.wrap)
      .provideEnvironment(r)
  }
  def restoreTableFromSnapshot(
      request: zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.RestoreTableFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreTableFromSnapshot(request))
  def listTableRestoreStatus(
      request: zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.listTableRestoreStatus(request))
  def listTableRestoreStatusPaginated(
      request: zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTableRestoreStatusPaginated(request))
  def updateNamespace(
      request: zio.aws.redshiftserverless.model.UpdateNamespaceRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UpdateNamespaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNamespace(request))
  def createWorkgroup(
      request: zio.aws.redshiftserverless.model.CreateWorkgroupRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkgroup(request))
  def deleteWorkgroup(
      request: zio.aws.redshiftserverless.model.DeleteWorkgroupRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkgroup(request))
  def listEndpointAccess(
      request: zio.aws.redshiftserverless.model.ListEndpointAccessRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpointAccess(request))
  def listEndpointAccessPaginated(
      request: zio.aws.redshiftserverless.model.ListEndpointAccessRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointAccessPaginated(request))
  def getNamespace(
      request: zio.aws.redshiftserverless.model.GetNamespaceRequest
  ): ZIO[zio.aws.redshiftserverless.RedshiftServerless, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getNamespace(request))
  def getWorkgroup(
      request: zio.aws.redshiftserverless.model.GetWorkgroupRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetWorkgroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkgroup(request))
  def getSnapshot(
      request: zio.aws.redshiftserverless.model.GetSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSnapshot(request))
  def getUsageLimit(
      request: zio.aws.redshiftserverless.model.GetUsageLimitRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetUsageLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsageLimit(request))
  def putResourcePolicy(
      request: zio.aws.redshiftserverless.model.PutResourcePolicyRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def deleteUsageLimit(
      request: zio.aws.redshiftserverless.model.DeleteUsageLimitRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.DeleteUsageLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUsageLimit(request))
  def deleteEndpointAccess(
      request: zio.aws.redshiftserverless.model.DeleteEndpointAccessRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.DeleteEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpointAccess(request))
  def listRecoveryPoints(
      request: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecoveryPoints(request))
  def listRecoveryPointsPaginated(
      request: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListRecoveryPointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecoveryPointsPaginated(request))
  def getRecoveryPoint(
      request: zio.aws.redshiftserverless.model.GetRecoveryPointRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetRecoveryPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecoveryPoint(request))
  def getCredentials(
      request: zio.aws.redshiftserverless.model.GetCredentialsRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCredentials(request))
  def createEndpointAccess(
      request: zio.aws.redshiftserverless.model.CreateEndpointAccessRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.CreateEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpointAccess(request))
  def deleteSnapshot(
      request: zio.aws.redshiftserverless.model.DeleteSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.DeleteSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSnapshot(request))
  def listNamespaces(
      request: zio.aws.redshiftserverless.model.ListNamespacesRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.Namespace.ReadOnly
  ] = ZStream.serviceWithStream(_.listNamespaces(request))
  def listNamespacesPaginated(
      request: zio.aws.redshiftserverless.model.ListNamespacesRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListNamespacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNamespacesPaginated(request))
  def getEndpointAccess(
      request: zio.aws.redshiftserverless.model.GetEndpointAccessRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEndpointAccess(request))
  def createNamespace(
      request: zio.aws.redshiftserverless.model.CreateNamespaceRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.CreateNamespaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNamespace(request))
  def updateSnapshot(
      request: zio.aws.redshiftserverless.model.UpdateSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UpdateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSnapshot(request))
  def untagResource(
      request: zio.aws.redshiftserverless.model.UntagResourceRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listUsageLimits(
      request: zio.aws.redshiftserverless.model.ListUsageLimitsRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsageLimits(request))
  def listUsageLimitsPaginated(
      request: zio.aws.redshiftserverless.model.ListUsageLimitsRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsageLimitsPaginated(request))
  def updateWorkgroup(
      request: zio.aws.redshiftserverless.model.UpdateWorkgroupRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UpdateWorkgroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkgroup(request))
  def deleteResourcePolicy(
      request: zio.aws.redshiftserverless.model.DeleteResourcePolicyRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def listWorkgroups(
      request: zio.aws.redshiftserverless.model.ListWorkgroupsRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.Workgroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkgroups(request))
  def listWorkgroupsPaginated(
      request: zio.aws.redshiftserverless.model.ListWorkgroupsRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkgroupsPaginated(request))
  def listTagsForResource(
      request: zio.aws.redshiftserverless.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateUsageLimit(
      request: zio.aws.redshiftserverless.model.UpdateUsageLimitRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UpdateUsageLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUsageLimit(request))
  def createUsageLimit(
      request: zio.aws.redshiftserverless.model.CreateUsageLimitRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.CreateUsageLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUsageLimit(request))
  def tagResource(
      request: zio.aws.redshiftserverless.model.TagResourceRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getTableRestoreStatus(
      request: zio.aws.redshiftserverless.model.GetTableRestoreStatusRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTableRestoreStatus(request))
  def listSnapshots(
      request: zio.aws.redshiftserverless.model.ListSnapshotsRequest
  ): ZStream[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.Snapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.listSnapshots(request))
  def listSnapshotsPaginated(
      request: zio.aws.redshiftserverless.model.ListSnapshotsRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ListSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSnapshotsPaginated(request))
  def updateEndpointAccess(
      request: zio.aws.redshiftserverless.model.UpdateEndpointAccessRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.UpdateEndpointAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpointAccess(request))
  def restoreFromSnapshot(
      request: zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.RestoreFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreFromSnapshot(request))
  def deleteNamespace(
      request: zio.aws.redshiftserverless.model.DeleteNamespaceRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.DeleteNamespaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNamespace(request))
  def getResourcePolicy(
      request: zio.aws.redshiftserverless.model.GetResourcePolicyRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
  def restoreFromRecoveryPoint(
      request: zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.RestoreFromRecoveryPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreFromRecoveryPoint(request))
  def convertRecoveryPointToSnapshot(
      request: zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.convertRecoveryPointToSnapshot(request))
  def createSnapshot(
      request: zio.aws.redshiftserverless.model.CreateSnapshotRequest
  ): ZIO[
    zio.aws.redshiftserverless.RedshiftServerless,
    AwsError,
    zio.aws.redshiftserverless.model.CreateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshot(request))
}
